# pylint: disable=unused-import,abstract-method,unused-argument,no-member

##########################################################################################
# Settings
##########################################################################################
# Please review the in settings.py
from settings import SETTINGS
##########################################################################################
# Imports
##########################################################################################

import psynet.experiment
from psynet.timeline import (
    Timeline
)
from psynet.page import SuccessfulEndPage
from network_and_trial_definitions import make_experiment

from timeline_parts import (
    make_feedback_form,
    make_sound_check,
    make_questionnaire
)

import logging

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__file__)

# Make sure
assert SETTINGS['TARGET'] in SETTINGS['TARGETS']

##########################################################################################
# Experiment
##########################################################################################

class Exp(psynet.experiment.Experiment):
    timeline = Timeline(
        make_sound_check,
        make_questionnaire,

        make_experiment(SETTINGS['TARGET']),

        # Ask for some feedback
        make_feedback_form,
        SuccessfulEndPage()
    )


    def __init__(self, session=None):
        super().__init__(session)
        # Change this if you want to simulate multiple simultaneous participants.
        self.initial_recruitment_size = SETTINGS['INITIAL_RECRUITMENT_SIZE']


extra_routes = Exp().extra_routes()
